/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.MyInputStream;
import cds.aladin.Tok;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.BuilderAllsky;
import cds.allsky.BuilderGunzip;
import cds.allsky.BuilderMirror;
import cds.allsky.BuilderMoc;
import cds.allsky.BuilderTree;
import cds.allsky.BuilderUpdateDataSum;
import cds.allsky.Context;
import cds.allsky.ModeMerge;
import cds.allsky.Task;
import cds.fits.Fits;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import java.io.File;
import java.io.FileInputStream;

public class BuilderUpdate
extends Builder {
    private Builder b = null;
    private String[] OLD = new String[]{"properties", "index.html"};

    public BuilderUpdate(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.UPDATE;
    }

    @Override
    public void run() throws Exception {
        this.fillupContext();
        if (!this.context.isTaskAborting()) {
            this.builderMoc();
        }
        if (!this.context.isTaskAborting()) {
            this.builderDataSum();
        }
        if (!this.context.isTaskAborting()) {
            this.builderLowOrder();
        }
        if (!this.context.isTaskAborting()) {
            this.builderAllsky();
        }
        if (!this.context.isTaskAborting()) {
            this.builderCheck();
        }
    }

    private void fillupContext() throws Exception {
        int[] minmax;
        boolean live;
        boolean color;
        this.context.loadProperties();
        String s = this.context.prop.getProperty("dataproduct_subtype");
        boolean bl = color = s != null && s.indexOf("color") >= 0;
        if (color) {
            this.context.setColor("true");
        }
        boolean bl2 = live = s != null && s.indexOf("live") >= 0;
        if (live) {
            this.context.setLive(live);
        }
        if ((minmax = this.context.findMinMaxOrder())[0] == -1) {
            throw new Exception("No HiPS found in target dir [" + this.context.getOutputPath() + "] !");
        }
        this.context.setOrder(minmax[1]);
        int depth = 1;
        s = this.context.prop.getProperty("hips_cube_depth");
        try {
            depth = Integer.parseInt(s);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.context.setDepth(depth);
        s = this.context.prop.getProperty("hips_frame");
        try {
            int frame = Context.getFrameVal(s);
            this.context.setFrame(frame);
        }
        catch (Exception frame) {
            // empty catch block
        }
        s = this.context.prop.getProperty("hips_status");
        if (s != null) {
            this.context.setStatus(s);
        }
        int tileSideByNpixFile = this.context.getTileWidthByNpixFile(this.context.getOutputPath());
        this.context.setTileOrder((int)CDSHealpix.log2(tileSideByNpixFile));
        this.context.initRegion();
    }

    private void keepOldCopy() throws Exception {
        String path = this.context.getOutputPath();
        for (String f : this.OLD) {
            this.keepOldCopy(path + Util.FS + f);
        }
    }

    private void keepOldCopy(String f) throws Exception {
        if (!new File(f).exists()) {
            return;
        }
        File max = new File(f + ".9");
        if (max.exists()) {
            max.delete();
        }
        for (int i = 9; i > 1; --i) {
            File fo = new File(f + (i == 1 ? "" : "." + (i - 1)));
            if (!fo.exists()) continue;
            fo.renameTo(new File(f + "." + i));
        }
        BuilderMirror.copyLocal(f, f + ".1");
    }

    private void builderDataSum() throws Exception {
        Fits f = new Fits();
        try {
            f.loadFITS(Context.findOneNpixFile(this.context.getOutputPath()));
        }
        catch (Exception e) {
            return;
        }
        if (f.headerFits.hasKey("DATASUM")) {
            this.context.info("DATASUM seems to be already present in tiles (to update them use \"UPDATEDATASUM\" action)");
            return;
        }
        this.context.info("Scanning and adding DATASUM on FITS tiles...");
        this.b = new BuilderUpdateDataSum(this.context);
        this.b.run();
        this.context.done("Datasum done");
        this.b = null;
    }

    private void builderCheck() throws Exception {
        if (this.context.getCheckCodeFromProp() != null) {
            this.context.info("Checkcodes already present (to update them use \"CHECKCODE\" action)");
            return;
        }
        this.context.info("Adding check codes...");
        Task.factoryRunner(this.context, Action.CHECKCODE);
        this.context.writePropertiesFile();
        this.context.done("Check code done");
        this.b = null;
    }

    private void builderGunzip() throws Exception {
        boolean isGZ = false;
        try (MyInputStream in = null;){
            in = new MyInputStream(new FileInputStream(Context.findOneNpixFile(this.context.getOutputPath())));
            isGZ = in.isGZ();
        }
        if (!isGZ) {
            this.context.info("Tiles seem to be already gunzipped (use \"GUNZIP\" to be sure)");
            return;
        }
        this.context.info("Scanning and gunzipping required tiles (order<=5) if required...");
        this.b = new BuilderGunzip(this.context);
        this.b.run();
        if (((BuilderGunzip)this.b).nbFile == 0) {
            this.context.info("Nothing gzipped");
        } else {
            this.context.done("Gunzip done");
        }
        this.b = null;
    }

    private void builderMoc() throws Exception {
        try {
            this.context.loadMoc();
            if (this.context.moc.getMocOrder() == 29) {
                this.context.info("Suspicious MOC order (29) !");
                this.keepOldCopy("Moc.fits");
            }
        }
        catch (Exception e) {
            this.context.info("Regenerating MOC from max order tiles...");
            this.b = new BuilderMoc(this.context);
            this.b.run();
            this.context.done("MOC regenerated from max order tiles");
            this.context.loadMoc();
            this.b = null;
        }
    }

    private void builderAllsky() throws Exception {
        this.b = new BuilderAllsky(this.context);
        ((BuilderAllsky)this.b).postJob();
    }

    private void builderLowOrder() throws Exception {
        int[] minmax = this.context.findMinMaxOrder();
        if (minmax[0] == 0) {
            return;
        }
        if (this.context.getMinOrder() == minmax[0]) {
            return;
        }
        boolean flagFits = false;
        int bitpixOrig = this.context.getBitpixOrig();
        this.context.setModeMerge(ModeMerge.mergeKeepTile);
        int order = this.context.getOrder();
        this.context.setOrder(3);
        this.context.info("Building missing HiPS low orders (Norder0,1 and 2)...");
        String s = this.context.prop.getProperty("hips_tile_format");
        Tok tok = new Tok(s);
        while (tok.hasMoreTokens()) {
            String fmt = tok.nextToken();
            if (fmt.equals("fits")) {
                flagFits = true;
                continue;
            }
            this.context.info("- building Norder0,1 and 2 for " + fmt + " tiles...");
            this.context.setColor(fmt);
            this.b = new BuilderTree(this.context);
            this.b.build();
        }
        this.context.bitpixOrig = bitpixOrig;
        this.context.order = order;
        if (flagFits && bitpixOrig != 0) {
            this.context.info("- building Norder0, 1 and 2 for fits tiles...");
            this.b = new BuilderTree(this.context);
            this.b.build();
        }
        this.context.setMinOrder(0);
        this.context.done("Norder0,1 and 2 successfully built");
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
        if (this.context.hipsId != null) {
            this.context.setHipsId(this.context.hipsId);
        } else {
            this.context.loadProperties();
            this.context.setHipsId(null);
        }
    }
}

